/**
 * Beschrijft een ridderharnas.
 *
 * @author Dominiek Vandewalle
 * @version 2015-06-30
 */
public class Harnas
{
    //velden
   private String type;
   private double beschermingsfactor;//getal tussen 0 (geen bescherming)
                                    //en 1(totale bescherming)
   
   /**
   * Constructor voor objecten van de klasse Harnas.
   * 
   * @param type    Het type van het harnas.
   * @param beschermingsfactor De mate waarin het harnas de ridder beschermt.
   * Dit is een getal tussen 0 (= geen bescherming) en 1 (= totale bescherming).
   */
   public Harnas(String type, double beschermingsfactor)
   {
       this.type = type;
       this.beschermingsfactor = beschermingsfactor;
   }
   
   /**
    * Geeft de beschermingsfactor van het harnas terug.
    * @return De beschrmingsfactor van het harnas.
    */
   public double getBeschermingsfactor()
   {
       return beschermingsfactor;
   }
   
   /**
    * Geeft het type van het harnas terug.
    * @String   Het type van het harnas.
    */
   public String getType()
   {
       return type;
   }
   
   /**
    * Info over het type en beschermingsfactor van het harnas geven
    * @return   Info over het harnas.
    */
   public String toString()
   {
       return type + " -> beschermingsfactor = " + beschermingsfactor;
   }
}